function [resid, struct_param, endo_ss, phis] = calibrate_ss_resid(xi, estim_param, calib_targets)
% This function computes the residuals given a guess of xi, phi_RC, and F_o

% est_par_names = {'beta', 'epsilon', 'alpha', 'eta', 'psi', 'lambda', 'nu', 'delta', 'gamma'};
% for i = 1:length(est_par_names)
%     eval([est_par_names{i} ' = estim_param.' est_par_names{i} ';']);
% end

beta    = estim_param.beta;
epsilon = estim_param.epsilon;
alpha   = estim_param.alpha;
eta     = estim_param.eta;
% psi     = estim_param.psi;
lambda  = estim_param.lambda;
nu      = estim_param.nu;
delta   = estim_param.delta;
gamma   = estim_param.gamma;

cal_tar_names = {'theta_n', 'theta_o', 'MS_o', 'R_o', 'L'};
for i = 1:length(cal_tar_names)
    eval([cal_tar_names{i} ' = calib_targets.' cal_tar_names{i} ';']);
end

theta_o = theta_o;
theta_n = theta_n;
L       = L;

r       = 1/beta - (1-delta);
beta_til= beta;

% Can I calibrate psi so that p = 1? 
% We know p = beta/(1-beta) * psi * (eta-1) * theta_n^eta + eta*psi*theta_n^(eta-1)
psi     = 1/(beta/(1-beta) * (eta-1) * theta_n^eta + eta*theta_n^(eta-1));

mu_1_n  = beta/(1-beta) * psi * (eta-1) * theta_n^eta;
p       = mu_1_n + eta*psi*theta_n^(eta-1);
mu_2_n  = lambda/(1-beta*(1-lambda)) * mu_1_n;

s_o     = (R_o * p^(epsilon-1))^(1/epsilon);

% Find K and Y
K       = (alpha * (1-s_o) * ((1-s_o)/(1-s_o*(R_o/p)^((epsilon-1)/epsilon)))^(1/(epsilon-1)) * L^(1-alpha) / r)^(1/(1-alpha));
VA      = K^alpha * L^(1-alpha);
Y       = ((1-s_o)/(1-s_o*(R_o/p)^((epsilon-1)/epsilon)))^(epsilon/(epsilon-1)) * VA;

% Use Y guess: we know F_o*theta_o/o = MS_o
o       = R_o * Y / p;
F_o     = MS_o*o/theta_o; 
F_n     = (o - F_o*theta_o)/theta_n;
X_n     = (F_n*theta_n)/lambda;
X_o     = (F_o*theta_o)/lambda;

% VA      = ((Y^((epsilon-1)/epsilon)-s_o * o^((epsilon-1)/epsilon))/(1-s_o))^(epsilon/(epsilon-1));
% K       = 1/r * alpha * (1-s_o) * Y^(1/epsilon) * VA^((epsilon-1)/epsilon);
w       = r / (alpha/(1-alpha) * L/K);
varphi  = w / (L^nu);


% Use xi guess: I_n^(1-xi) = xi G_n^(1-xi) mu_2_n & I_n^xi G_n^(1-xi) = F_n theta_n
I2G_n   = (xi*mu_2_n)^(1/(1-xi));
I_n     = I2G_n^(1-xi) * F_n * theta_n;
G_n     = I_n / I2G_n;

I2G_o   = (xi * lambda/(1-beta*(1-lambda)) * beta/(1-beta) * psi * (eta-1) *theta_o^(eta))^(1/(1-xi));
I_o     = I2G_o^(1-xi) * F_o * theta_o;
G_o     = I_o/I2G_o;

C       = Y - delta * K - I_n - I_o - psi*theta_n^eta*F_n - psi*theta_o^eta*F_o;


f_target = @(x) res_RC(x, beta, psi, eta, theta_o, p, lambda, ...
     theta_n, xi, I2G_n, I_n, mu_2_n, F_n, F_o, epsilon, o, Y, s_o, r, K, w, alpha, nu, L, mu_1_n, varphi, gamma, I_o, C);

evalc('[phi_RC, ~, flag] = fsolve(f_target, -1);');

% Use phi_RC:
mu_1_o  = beta/(1-beta) * psi* (eta-1)*theta_o^(eta) *(1-phi_RC);
phi_O   = p - mu_1_o - eta*psi*theta_o^(eta-1) * (1-phi_RC);
mu_2_o  = lambda/(1-beta*(1-lambda)) * mu_1_o;

phi_mu_1    = beta/(1-beta*(1-theta_n)) * (theta_n*phi_O -psi*theta_n^(eta)*phi_RC);
phi_mu_2    = lambda/(1-beta*(1-lambda)) * phi_mu_1;
phi_I       = (phi_mu_2 - 1/xi * I2G_n^(1-xi)*phi_RC)/((1-xi)*I_n^(-1)*mu_2_n);
phi_theta   = F_n * (phi_O - eta*psi*theta_n^(eta-1)*phi_RC - phi_mu_1) / (eta*(eta-1)*psi*theta_n^(eta-2));
phi_X       = xi/lambda * I2G_n^(xi-1) * phi_I;
phi_F       = (lambda*phi_X - phi_theta)/theta_n;
phi_P       = theta_o * F_o - theta_n*phi_F - phi_theta;
phi_Y       = (1/epsilon *Y^(1/epsilon)*s_o*o^(-1/epsilon-1) * phi_P - phi_O)/(Y^(1/epsilon)*s_o*o^(-1/epsilon));

% Finding phi_r and phi_w
%  Can get w phi_w + r phi_r:
wphi_rphi = (phi_Y + phi_RC)*epsilon*Y - p * phi_P;
phi_r     = ((phi_Y + phi_RC)*r*K + (epsilon-1)/epsilon*alpha*wphi_rphi)/r;
phi_w     = (wphi_rphi - r * phi_r)/w;
phi_K     = phi_r;
phi_L     = w * phi_w * nu/L;
phi_beta  = -((p*theta_n + (1-theta_n)*mu_1_n - psi*theta_n^(eta))*phi_F + (1-lambda)*mu_2_n*phi_X - 1/beta*phi_K)/beta;

Mutil   = C - varphi * L^(1+nu)/(1+nu);
 
resid    = -w * phi_RC + phi_L * ((1-((epsilon-1)/epsilon)*(1-alpha))/nu+1) ...
        - (epsilon-1)/epsilon*(1-alpha)*r/L*phi_r - w*phi_Y;

st_param_names = {'beta', 'epsilon', 'alpha', 'eta', 'psi', 'lambda', 'nu', ...
                  'delta', 'gamma', 'xi', 'G_n', 'G_o', 's_o', 'varphi'};
for i = 1:length(st_param_names)
    eval(['struct_param.' st_param_names{i} ' = ' st_param_names{i} ';']);
end


endo_ss_names = {'p' 'I_o' 'I_n' 'F_o' 'F_n' 'X_o' 'X_n' 'theta_o' 'theta_n' ...
  'VA' 'mu_1_n' 'mu_2_n' 'mu_1_o' 'mu_2_o' 'o' 'Y' 'K' 'L' 'C' 'r' 'w' 'beta_til'};
for i = 1:length(endo_ss_names)
    eval(['endo_ss.' endo_ss_names{i} ' = ' endo_ss_names{i} ';']);
end

phi_names = {'mu_1' 'mu_2' 'I' 'theta' 'X' 'F' 'P' 'Y' 'r' 'O' ...
                 'w' 'K' 'L' 'beta' 'RC'};
for i = 1:length(phi_names)
    eval(['phis.' phi_names{i} ' = phi_' phi_names{i} ';']);
end


% keyboard

function resid_phi_RC = res_RC(phi_RC, beta, psi, eta, theta_o, p, lambda, ...
     theta_n, xi, I2G_n, I_n, mu_2_n, F_n, F_o, epsilon, o, Y, s_o, r, K, w, alpha, nu, L, mu_1_n, varphi, gamma, I_o, C)

mu_1_o  = beta/(1-beta) * psi* (eta-1)*theta_o^(eta) *(1-phi_RC);
phi_O   = p - mu_1_o - eta*psi*theta_o^(eta-1) * (1-phi_RC);
mu_2_o  = lambda/(1-beta*(1-lambda)) * mu_1_o;

phi_mu_1    = beta/(1-beta*(1-theta_n)) * (theta_n*phi_O -psi*theta_n^(eta)*phi_RC);
phi_mu_2    = lambda/(1-beta*(1-lambda)) * phi_mu_1;
phi_I       = (phi_mu_2 - 1/xi * I2G_n^(1-xi)*phi_RC)/((1-xi)*I_n^(-1)*mu_2_n);
phi_theta   = F_n * (phi_O - eta*psi*theta_n^(eta-1)*phi_RC - phi_mu_1) / (eta*(eta-1)*psi*theta_n^(eta-2));
phi_X       = xi/lambda * I2G_n^(xi-1) * phi_I;
phi_F       = (lambda*phi_X - phi_theta)/theta_n;
phi_P       = theta_o * F_o - theta_n*phi_F - phi_theta;
phi_Y       = (1/epsilon *Y^(1/epsilon)*s_o*o^(-1/epsilon-1) * phi_P - phi_O)/(Y^(1/epsilon)*s_o*o^(-1/epsilon));

% Finding phi_r and phi_w
%  Can get w phi_w + r phi_r:
wphi_rphi = (phi_Y + phi_RC)*epsilon*Y - p * phi_P;
phi_r     = ((phi_Y + phi_RC)*r*K + (epsilon-1)/epsilon*alpha*wphi_rphi)/r;
phi_w     = (wphi_rphi - r * phi_r)/w;
phi_K     = phi_r;
phi_L     = w * phi_w * nu/L;
phi_beta  = -((p*theta_n + (1-theta_n)*mu_1_n - psi*theta_n^(eta))*phi_F + (1-lambda)*mu_2_n*phi_X - 1/beta*phi_K)/beta;

Mutil   = C - varphi * L^(1+nu)/(1+nu);

resid_phi_RC    = phi_RC * Mutil - gamma*beta*(1-beta)*phi_beta - gamma*(theta_o*F_o*p - I_o - psi*theta_o^(eta)*F_o);


